
import React, { useState } from 'react';
import { View, Text } from "react-native";
import LoggedInUser from './LoggedInUser'
import LoggedOutUser from './LoggedOutUser'
import DisplayAnImage from './DisplayAnImage'


const App = () => {
  const [logged, setLogged] = useState(false);
  const handleClick = () => {
    const newLog = !logged;
    setLogged(newLog);
  }

  //  1 -- variable
  /*
  let button;
  if (logged == false) {
    button = <LoggedInUser handleClick={handleClick} />
  } else {
    button = <LoggedOutUser handleClick={handleClick} />
  }
  */
  //2 - function with switch
  /*
  const button = () => {
    switch (logged) {
      case true:
        return <LoggedInUser handleClick={handleClick} />;
      case false:
        return <LoggedOutUser handleClick={handleClick} />;
      default:
        return null;
    }
  };
  */
  //3 - variable with ternary operator
  const button = logged == false ? <LoggedInUser handleClick={handleClick} /> : <LoggedOutUser handleClick={handleClick} />;

  return (
    <View style={{ flex: 1, flexDirection: "column", alignItems: "center", justifyContent: "space-around", padding: 6 }}>

      <Text>
        This is a Demo showing several ways to implement Conditional Rendering in React.
      </Text>


      {
        //button //1 - using variable (if)
        //button() //2 -  using function (switch)
        button //3 - using variable (ternary operator)

      }
      {logged && <DisplayAnImage />}

    </View>

  );
}

export default App;
